// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef HW_GX_H
#define HW_GX_H

#include "hw_internal.h"

#define GXI_GPS(macro) macro(BASE, base, 0x20, SIMPLE) macro(END, end, 0x24, SIMPLE)\
	macro(HIWATER, hiwater, 0x28, SIMPLE) macro(LOWATER, lowater, 0x2C, SIMPLE)\
	macro(DIST, dist, 0x30, DIST) macro(WRITEPTR, writeptr, 0x34, ALIGN)\
	macro(READPTR, readptr, 0x38, ALIGN) macro(BREAKPOINT, breakpoint, 0x3C, SIMPLE)
#define GXI_CPUS(macro) macro(BASE, base, 0x300C) macro(END, end, 0x3010)\
	macro(WRITEPTR, writeptr, 0x3014)

class HwGX {
public:
	static void wb_fifo(Hardware *h, WORD offset, BYTE data);
	static void wh_fifo(Hardware *h, WORD offset, WORD data);
	static void ww_fifo(Hardware *h, WORD offset, DWORD data);
	static void wd_fifo(Hardware *h, WORD offset, QWORD data);

	static void wh_pe_isr(Hardware *h, WORD offset, WORD data);

	static WORD rh_cp_sr(Hardware *h, WORD offset);
	static void wh_cp_cr(Hardware *h, WORD offset, WORD data);
	static void wh_cp_clear(Hardware *h, WORD offset, WORD data);
	static void wh_cp_metric(Hardware *h, WORD offset, WORD data);

#define DECLARE_GXI_CPU(cap, gem, address)\
	static void ww_cpufifo_##gem(Hardware *h, WORD offset, DWORD data);\
	static DWORD rw_cpufifo_##gem(Hardware *h, WORD offset);
	GXI_CPUS(DECLARE_GXI_CPU);

#define DECLARE_GXI_GP(cap, gem, address, rhlo)\
	static void wh_gpfifo_##gem##_lo(Hardware *h, WORD offset, WORD data);\
	static void wh_gpfifo_##gem##_hi(Hardware *h, WORD offset, WORD data);\
	static WORD rh_gpfifo_##gem##_lo(Hardware *h, WORD offset);\
	static WORD rh_gpfifo_##gem##_hi(Hardware *h, WORD offset);
	GXI_GPS(DECLARE_GXI_GP);

	static void check_wpe(Hardware *h);
	static void do_underflow(Hardware *h);
private:
	static void wrapWrite(Hardware *h, BYTE *data, size_t size);
	template<class T> static void w_fifo(Hardware *h, WORD offset, T data);
	static void signalGPThread(Hardware *h);
	static void check_fifo_link(Hardware *h);
	static void check_fifo_read(Hardware *h);
	static WORD rh_gpfifo_lo_align(Hardware *h, WORD offset, const char *name, WORD data);
	static bool fifo_is_flushed(Hardware *h);
	static DWORD update_dist(Hardware *h);
	static void stabilize_fifo(Hardware *h);
	static void handle_gp_fifo_change(Hardware *h);
};

//#define ENUM_GXI_GP(cap, gem, address, rhlo) GXI_GP_##cap##_LO, GXI_GP_##cap##_HI,
//#define ENUM_GXI_CPU(cap, gem, address) GXI_CPU_##cap,
//enum GXInitBits { GXI_CPUS(ENUM_GXI_CPU) GXI_GPS(ENUM_GXI_GP) GXI_ALL };
//#define FIFO_INITIALIZED (h->fifo.initialized == (1 << GXI_GP_BREAKPOINT_LO) - 1)

#define IS_32B_ALIGNED(word) (((word) & 31) == 0)
//#define IS_ENDPTR_ALIGNED(word) IS_32B_ALIGNED((word) + 4)
#define PAD_ENDPTR(word) FLOOR_32B((word) + 32)
#define GPFIFO_SIZE (PAD_ENDPTR(h->fifo.gp.end) - h->fifo.gp.base)
#define WRAP_GPFIFOPTR(word, gpfifo) (((word) > PAD_ENDPTR((gpfifo).end)) ?\
	((word) - PAD_ENDPTR((gpfifo).end) + (gpfifo).base) : (word))
#define FLOOR_32B(word) ((word) & ~31)
#define CALCULATE_DIST(writeptr, readptr, base, end) ((writeptr >= readptr) ?\
	(writeptr - readptr) : (end - readptr + writeptr - base))
#define PTR2ADDRESS(ptr) (DWORD(ptr - h->fifo.pBase) + h->fifo.cpu.base)

#define CPSR 0x0000
#define CPSR_BREAKPOINT 0x10
#define CPSR_IDLE_COMMAND 8
#define CPSR_IDLE_READING 4
#define CPSR_UNDERFLOW 2
#define CPSR_OVERFLOW 1

#define CPCR 0x0002

#define PERF_CP(std) std(NONE, 0) std(FIFO_REQ, 2) std(CALL_REQ, 3) std(VC_MISS_REQ, 4)\
	std(CP_ALL_REQ, 5)

#ifndef _DEBUG
#define RELEASE_ASSERT(b) if(!(b)) throw hardware_fatal_exception("Assertion failed: "#b)
#else
#define RELEASE_ASSERT MYASSERT
#endif
#define FIFODEGUB if(g::fifo_log) DEGUB

#endif	//HW_GX_H
